#ifdef SKINNING

uniform mat4 	boneMatrices[100];
attribute vec4	weights;
attribute vec4 	matrixIndices;

#endif

varying float 		distance;
varying vec2 		texcoord;	
uniform float 		maxdist,
					mindist;
varying vec2		depth;

void main()
{
#ifdef SKINNING

	vec4 position = vec4( 0.0, 0.0, 0.0, 0.0 );

  	position = position + ((boneMatrices[int(matrixIndices.x)] * gl_Vertex) * weights.x);
	position = position + ((boneMatrices[int(matrixIndices.y)] * gl_Vertex) * weights.y);
	position = position + ((boneMatrices[int(matrixIndices.z)] * gl_Vertex) * weights.z);
	position = position + ((boneMatrices[int(matrixIndices.w)] * gl_Vertex) * weights.w);
	gl_Position = gl_ModelViewProjectionMatrix * position;
	//depth=-(gl_ModelViewMatrix * position).z;

#else

	gl_Position = ftransform();
	//depth=-(gl_ModelViewMatrix * gl_Vertex).z;

#endif

	depth=gl_Position.zw;
	texcoord=gl_MultiTexCoord0.xy;	

	float dist=(gl_Position.z-mindist)/(maxdist-mindist);
	distance=1.0 - (clamp(dist,0.0,1.0));
}